/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************//*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : PRESETTABLE DECADE COUNTERS/LATCHES
TRUTHTABLE     : 
          BCD COUNT MODE             BI-QUINARY COUNT MODE
             SEE NOTE 1                 SEE  NOTE 2
         -------------------         ------------------- 
         COUNT  QD QC QB QA          COUNT  QD QC QB QA  
         -------------------         ------------------- 
           0    L  L  L  L             0    L  L  L  L   
           1    L  L  L  H             1    L  L  L  H   
           2    L  L  H  L             2    L  L  H  L   
           3    L  L  H  H             3    L  L  H  H   
           4    L  H  L  L             4    L  H  L  L   
           5    L  H  L  H             5    H  L  L  L   
           6    L  H  H  L             6    H  L  L  H   
           7    L  H  H  H             7    H  L  H  L   
           8    H  L  L  L             8    H  L  H  H   
           9    H  L  L  H             9    H  H  L  L   
         -------------------         -------------------   
        NOTES : 1. OUTPUT QA CONNECTED TO CLOCK-2 INPUT.
                2. OUTPUT QD CONNECTED TO CLOCK-1 INPUT.
                     
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a196 (ldn, qc, c, a, qa, clk2, clk1, qb, b, d, qd, clrn);
	parameter size =1;
	input
		ldn,
		c,
		a,
		clk2,
		clk1,
		b,
		d,
		clrn;
	output
		qc,
		qa,
		qb,
		qd;
    reg
        NOTIFY_REG;
    and
	  (en, clrn, ldn);
    nand
	M196N_inst_N1 (m196n_inst_apre, a, m196n_inst_wclrb, m196n_inst_wn1);
    nand  
	M196N_inst_N2 (m196n_inst_aclr, m196n_inst_apre, m196n_inst_wn1);
    nand
	M196N_inst_N3 (m196n_inst_bpre, b, m196n_inst_wclrb, m196n_inst_wn1);
    nand
	M196N_inst_N4 (m196n_inst_bclr, m196n_inst_bpre, m196n_inst_wn1);
    nand
	M196N_inst_N5 (m196n_inst_cpre, c, m196n_inst_wclrb, m196n_inst_wn1);
    nand  
	M196N_inst_N6 (m196n_inst_cclr, m196n_inst_cpre, m196n_inst_wn1);
    nand
	M196N_inst_N7 (m196n_inst_dpre, d, m196n_inst_wclrb, m196n_inst_wn1);
    nand  
	M196N_inst_N8 (m196n_inst_dclr, m196n_inst_dpre, m196n_inst_wn1);
    nand  
	M196N_inst_N9 (m196n_inst_wn1, ldn, clrn);
    buf
	M196N_inst_B1 (m196n_inst_wclrb, clrn);
    and
	M196N_inst_A1 (m196n_inst_wa1, m196n_inst_qbint, m196n_inst_qcint);
    not
	  (m196n_inst_nclk1, clk1);
    not
	  (m196n_inst_nclk2, clk2);
    buf
	  (qa, m196n_inst_qaint);
    buf  
	  (qb, m196n_inst_qbint);
    buf
	  (qc, m196n_inst_qcint);
    buf  
	  (qd, m196n_inst_qdint);
    not
	  (m196n_inst_qbb, m196n_inst_qbint);
    not
	  (m196n_inst_qdb, m196n_inst_qdint);
    U_FT_P_SB_RB_NO  
	M196N_inst_Inst1_inst1 (m196n_inst_qaint, m196n_inst_nclk1, m196n_inst_aclr, m196n_inst_apre, NOTIFY_REG);
    U_FJK_P_RB_SB_NO  
	M196N_inst_Inst2_inst1 (m196n_inst_qbint, m196n_inst_qdb, m196n_inst_qdb, m196n_inst_nclk2, m196n_inst_bclr, m196n_inst_bpre, NOTIFY_REG);
    U_FT_P_SB_RB_NO  
	M196N_inst_Inst3_inst1 (m196n_inst_qcint, m196n_inst_qbb, m196n_inst_cclr, m196n_inst_cpre, NOTIFY_REG);
    U_FJK_P_RB_SB_NO
	M196N_inst_Inst4_inst1 (m196n_inst_qdint, m196n_inst_wa1, m196n_inst_qdint, m196n_inst_nclk2, m196n_inst_dclr, m196n_inst_dpre, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
